package attivita_atomiche;

import eventi.*;
import giocatori.*;

import java.util.Iterator;

import partecipante.*;
import partita.*;

import _framework.Executor;
import _framework.Task;
import _gestioneeventi.Environment;
import _gestioneeventi.EsecuzioneEnvironment;

public class Gioca implements Task {

	private boolean eseguita = false;
	private Partita partita;

	public Gioca(Partita t) {
		this.partita = t;
	}

	public synchronized void esegui(Executor e) {

		if (e == null || eseguita == true)
			return;
		eseguita = true;

		Iterator<TipoLinkGiocatori> it = partita.getLinkGiocatori().iterator();
		while (it.hasNext()) {
			Partecipante p = it.next().getPartecipante();
			EsecuzioneEnvironment.addListener(p);
		}

		Environment.aggiungiEvento(new Inizio(null, null));
		Environment.aggiungiEvento(new Bottiglia(null, partita
				.getLinkGiocatori().get(0).getPartecipante()));
		EsecuzioneEnvironment.attivaListener();
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
}