package torello;

import java.util.*;

import comprendereGiocatoriGialli.*;
import comprendereGiocatoriRossi.*;

public class Torello {
	private final String nome;
	private ArrayList<TipoLinkComprendereGiocatoriGialli> insG;
	private ArrayList<TipoLinkComprendereGiocatoriRossi> insR;
	public final int MINCOMPRENDERE = 1;

	public Torello(String n) {
		nome = n;
		insG = new ArrayList<TipoLinkComprendereGiocatoriGialli>();
		insR = new ArrayList<TipoLinkComprendereGiocatoriRossi>();
	}

	public String getNome() {
		return nome;
	}

	public void inserisciLinkComprendereGiocatoriGialli(TipoLinkComprendereGiocatoriGialli t) {
		if (t != null && t.getTorello() == this)
			ManagerComprendereGiocatoriGialli.inserisci(t);
	}

	public void eliminaLinkComprendereGiocatoriGialli(TipoLinkComprendereGiocatoriGialli t) {
		if (t != null && t.getTorello() == this)
			ManagerComprendereGiocatoriGialli.elimina(t);
	}

	@SuppressWarnings("unchecked")
	public List<TipoLinkComprendereGiocatoriGialli> getLinkComprendereGiocatoriGialli() {
		if (quantiGiocatoriGialli() < MINCOMPRENDERE)
			throw new RuntimeException("Eccezione Molteplicita'");
		return (ArrayList<TipoLinkComprendereGiocatoriGialli>) insG.clone();
	}

	public void inserisciPerManagerComprendereGiocatoriGialli(ManagerComprendereGiocatoriGialli a) {
		if (a != null && !insG.contains(a.getLink()))
			insG.add(a.getLink());
	}

	public void eliminaPerManagerComprendereGiocatoriGialli(ManagerComprendereGiocatoriGialli a) {
		if (a != null)
			insG.remove(a.getLink());
	}

	public int quantiGiocatoriGialli() {
		return insG.size();
	}

	public void inserisciLinkComprendereGiocatoriRossi(TipoLinkComprendereGiocatoriRossi t) {
		if (t != null && t.getTorello() == this)
			ManagerComprendereGiocatoriRossi.inserisci(t);
	}

	public void eliminaLinkComprendereGiocatoriRossi(TipoLinkComprendereGiocatoriRossi t) {
		if (t != null && t.getTorello() == this)
			ManagerComprendereGiocatoriRossi.elimina(t);
	}

	@SuppressWarnings("unchecked")
	public List<TipoLinkComprendereGiocatoriRossi> getLinkComprendereGiocatoriRossi() {
		if (quantiGiocatoriRossi() < MINCOMPRENDERE)
			throw new RuntimeException("Eccezione Molteplicita'");
		return (ArrayList<TipoLinkComprendereGiocatoriRossi>) insR.clone();
	}

	public void inserisciPerManagerComprendereGiocatoriRossi(ManagerComprendereGiocatoriRossi a) {
		if (a != null && !insR.contains(a.getLink()))
			insR.add(a.getLink());
	}

	public void eliminaPerManagerComprendereGiocatoriRossi(ManagerComprendereGiocatoriRossi a) {
		if (a != null)
			insR.remove(a.getLink());
	}

	public int quantiGiocatoriRossi() {
		return insR.size();
	}

	public String toString() {
		return nome;
	}
}
