package giocatore;

import eventi.Fine;
import eventi.Inizio;
import eventi.Palla;
import giocatoreGiallo.GiocatoreGiallo;
import giocatoreRosso.GiocatoreRosso;
import _framework.Executor;
import _framework.Task;
import _gestioneeventi.Environment;
import _gestioneeventi.Evento;

class GiocatoreFired implements Task {
	private boolean eseguita = false;
	private Giocatore g;
	private Evento e;
	
	private int indexR = 0;
	private int indexG = 0;
	
	public GiocatoreFired(Giocatore g, Evento e) {
		this.g = g;
		this.e = e;
	}

	// usati per scegliere a chi lanciare la palla
	
	// i gialli scelgono di lanciare la palla al
	// prossimo rosso nell'insieme ordinato
	private int scegliRosso() {
    
		int numRossi = ((GiocatoreGiallo)g).
    			getLinkComprendereGiocatoriGialli().
    			getTorello().quantiGiocatoriRossi();
    	
		indexR ++;
    	return indexR % numRossi;
    }
    
	// i rossi scelgono di lanciare la palla 
    // ogni due giocatori gialli
    private int scegliGiallo() {
    	int numGialli = ((GiocatoreRosso)g).
    			getLinkComprendereGiocatoriRossi().
    			getTorello().quantiGiocatoriGialli();
    	
    	indexG = indexG + 2;
    	return indexG % numGialli;
    }
    
	public synchronized void esegui(Executor exec) {
		if (eseguita || exec == null
				|| (e.getDestinatario() != g && e.getDestinatario() != null))
			return;
		eseguita = true;
		System.out.println("Entrato nel fired di " + g);
		
		switch (g.getStato()) {
		case NONINGIOCO:
			if (e.getClass() == Inizio.class) {
				g.statocorrente = giocatore.Giocatore.Stato.INGIOCO;
			}
			break;
		case INGIOCO:
			if (e.getClass() == Palla.class) {
				Palla d = (Palla) e;

				if (g.getClass() == GiocatoreGiallo.class)
				{
					System.out.println(d);
					
					// per far giocare tutti s controlla che la palla
					// non venga rispedita a chi te la ha appena
					// lanciata
					
					int prossimo = scegliRosso();
					GiocatoreRosso dest = ((GiocatoreGiallo)g).getLinkComprendereGiocatoriGialli().getTorello().getLinkComprendereGiocatoriRossi().get(prossimo).getGiocatore();
										
					while (dest.equals(d.getMittente()))
					{
						prossimo = scegliRosso();
						dest = ((GiocatoreGiallo)g).getLinkComprendereGiocatoriGialli().getTorello().getLinkComprendereGiocatoriRossi().get(prossimo).getGiocatore();
					}
					
					System.out.println(g + " sceglie di lanciare a " + dest);
					Environment.aggiungiEvento(new Palla(g, dest, d.getIdPalla()));
				}
				else {
					System.out.println(d);
					
					// per far giocare tutti s controlla che la palla
					// non venga rispedita a chi te la ha appena
					// lanciata
					
					int prossimo = scegliGiallo();
					GiocatoreGiallo dest = ((GiocatoreRosso)g).getLinkComprendereGiocatoriRossi().getTorello().getLinkComprendereGiocatoriGialli().get(prossimo).getGiocatore();
										
					while (dest.equals(d.getMittente()))
					{
						prossimo = scegliGiallo();
						dest = ((GiocatoreRosso)g).getLinkComprendereGiocatoriRossi().getTorello().getLinkComprendereGiocatoriGialli().get(prossimo).getGiocatore();
					}
					
					System.out.println(g + " sceglie di lanciare a " + dest);
					Environment.aggiungiEvento(new Palla(g, dest, d.getIdPalla()));
				}
 
			} else if (e.getClass() == Fine.class)
				g.statocorrente = giocatore.Giocatore.Stato.NONINGIOCO;
			break;
		default:
			throw new RuntimeException("Stato corrente non riconosciuto.");
		}
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
}
