package giocatore;

import _framework.*;
import _gestioneeventi.*;

public abstract class Giocatore implements Listener {
	private final String nome;
	private String avatar;

	public Giocatore(String n) {
		nome = n;
	}

	public String getNome() {
		return nome;
	}

	public String getAvatar() {
		return avatar;
	}

	public void setAvatar(String avatar) {
		if (statocorrente != Stato.NONINGIOCO)
			throw new RuntimeException(
					"Non si puo' modificare il giocatore se non e' in allenamento");
		this.avatar = avatar;
	}

	// gestione stato

	public static enum Stato {
		NONINGIOCO, INGIOCO
	}

	Stato statocorrente = Stato.NONINGIOCO;

	public Stato getStato() {
		return statocorrente;
	}

	public void fired(Evento e) {
		Executor.perform(new GiocatoreFired(this, e));
	}

	public String toString() {
		return nome;
	}
}
