package comprendereGiocatoriRossi;

import giocatoreRosso.*;
import torello.*;

public class TipoLinkComprendereGiocatoriRossi {
	private final GiocatoreRosso ilGiocatore;
	private final Torello ilTorello;

	public TipoLinkComprendereGiocatoriRossi(GiocatoreRosso x, Torello y) {
		if (x == null || y == null) // CONTROLLO PRECONDIZIONI
			throw new RuntimeException(
					"Gli oggetti devono essere inizializzati");
		ilGiocatore = x;
		ilTorello = y;
	}

	public boolean equals(Object o) {
		if (o != null && getClass().equals(o.getClass())) {
			TipoLinkComprendereGiocatoriRossi b = (TipoLinkComprendereGiocatoriRossi) o;
			return b.ilGiocatore == ilGiocatore && b.ilTorello == ilTorello;
		} else
			return false;
	}

	public int hashCode() {
		return ilTorello.hashCode() + ilGiocatore.hashCode();
	}

	public Torello getTorello() {
		return ilTorello;
	}

	public GiocatoreRosso getGiocatore() {
		return ilGiocatore;
	}
}
