package comprendereGiocatoriRossi;

import giocatore.*;

public final class ManagerComprendereGiocatoriRossi {
	private ManagerComprendereGiocatoriRossi(TipoLinkComprendereGiocatoriRossi x) {
		link = x;
	}

	private TipoLinkComprendereGiocatoriRossi link;

	public TipoLinkComprendereGiocatoriRossi getLink() {
		return link;
	}

	public static void inserisci(TipoLinkComprendereGiocatoriRossi y) {
		if (y != null) {
			if (y.getGiocatore().getStato() != Giocatore.Stato.NONINGIOCO)
				throw new RuntimeException(
						"Non si puo' modificare un giocatore mentre sta giocando");
			ManagerComprendereGiocatoriRossi k = new ManagerComprendereGiocatoriRossi(y);
			y.getGiocatore().inserisciPerManagerComprendereGiocatoriRossi(k);
			y.getTorello().inserisciPerManagerComprendereGiocatoriRossi(k);
		}
	}

	public static void elimina(TipoLinkComprendereGiocatoriRossi y) {
		if (y != null) {
			if (y.getGiocatore().getStato() != Giocatore.Stato.NONINGIOCO)
				throw new RuntimeException(
						"Non si puo' modificare un giocatore mentre sta giocando");
			ManagerComprendereGiocatoriRossi k = new ManagerComprendereGiocatoriRossi(y);
			y.getGiocatore().eliminaPerManagerComprendereGiocatoriRossi(k);
			y.getTorello().eliminaPerManagerComprendereGiocatoriRossi(k);
		}
	}
}
