package comprendereGiocatoriGialli;

import giocatoreGiallo.*;
import torello.*;

public class TipoLinkComprendereGiocatoriGialli {
	private final GiocatoreGiallo ilGiocatore;
	private final Torello ilTorello;

	public TipoLinkComprendereGiocatoriGialli(GiocatoreGiallo x, Torello y) {
		if (x == null || y == null) // CONTROLLO PRECONDIZIONI
			throw new RuntimeException(
					"Gli oggetti devono essere inizializzati");
		ilGiocatore = x;
		ilTorello = y;
	}

	public boolean equals(Object o) {
		if (o != null && getClass().equals(o.getClass())) {
			TipoLinkComprendereGiocatoriGialli b = (TipoLinkComprendereGiocatoriGialli) o;
			return b.ilGiocatore == ilGiocatore && b.ilTorello == ilTorello;
		} else
			return false;
	}

	public int hashCode() {
		return ilTorello.hashCode() + ilGiocatore.hashCode();
	}

	public Torello getTorello() {
		return ilTorello;
	}

	public GiocatoreGiallo getGiocatore() {
		return ilGiocatore;
	}
}
