package comprendereGiocatoriGialli;

import giocatore.*;

public final class ManagerComprendereGiocatoriGialli {
	private ManagerComprendereGiocatoriGialli(TipoLinkComprendereGiocatoriGialli x) {
		link = x;
	}

	private TipoLinkComprendereGiocatoriGialli link;

	public TipoLinkComprendereGiocatoriGialli getLink() {
		return link;
	}

	public static void inserisci(TipoLinkComprendereGiocatoriGialli y) {
		if (y != null) {
			if (y.getGiocatore().getStato() != Giocatore.Stato.NONINGIOCO)
				throw new RuntimeException(
						"Non si puo' modificare un giocatore mentre sta giocando");
			ManagerComprendereGiocatoriGialli k = new ManagerComprendereGiocatoriGialli(y);
			y.getGiocatore().inserisciPerManagerComprendereGiocatoriGialli(k);
			y.getTorello().inserisciPerManagerComprendereGiocatoriGialli(k);
		}
	}

	public static void elimina(TipoLinkComprendereGiocatoriGialli y) {
		if (y != null) {
			if (y.getGiocatore().getStato() != Giocatore.Stato.NONINGIOCO)
				throw new RuntimeException(
						"Non si puo' modificare un giocatore mentre sta giocando");
			ManagerComprendereGiocatoriGialli k = new ManagerComprendereGiocatoriGialli(y);
			y.getGiocatore().eliminaPerManagerComprendereGiocatoriGialli(k);
			y.getTorello().eliminaPerManagerComprendereGiocatoriGialli(k);
		}
	}
}
