package attivita_composte;

import giocatoreGiallo.GiocatoreGiallo;
import giocatoreRosso.GiocatoreRosso;

import java.util.HashSet;

import torello.Torello;
import _framework.Executor;
import attivita_atomiche.InserisciInTorello;
import attivita_io.LeggiGiocatori;
import attivita_io.StampaPartita;

public class AttivitaPrincipale implements Runnable {

	private boolean eseguita = false;
	private Torello torello;
	private HashSet<GiocatoreGiallo> hsG;
	private HashSet<GiocatoreRosso> hsR;

	public AttivitaPrincipale(Torello t) {
		this.torello = t;
	}

	public synchronized void run() {
		if (eseguita == true)
			return;
		eseguita = true;
	
		LeggiGiocatori.perform();
		hsG = LeggiGiocatori.getInsiemeGialli();
		hsR = LeggiGiocatori.getInsiemeRossi();

		InserisciInTorello iit = new InserisciInTorello(torello,hsG,hsR);
		Executor.perform(iit);
		
		StampaPartita.perform(torello);

		AttivitaSottoramo1 a1 = new AttivitaSottoramo1(torello);
		Thread ramo1 = new Thread(a1);
		ramo1.start();

		AttivitaSottoramo2 a2 = new AttivitaSottoramo2();
		Thread ramo2 = new Thread(a2);
		ramo2.start();

		try {
			ramo1.join();
			ramo2.join();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}

	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
}
