package attivita_atomiche;

import giocatoreGiallo.GiocatoreGiallo;
import giocatoreRosso.GiocatoreRosso;

import java.util.HashSet;
import java.util.Iterator;

import torello.Torello;
import _framework.Executor;
import _framework.Task;

import comprendereGiocatoriGialli.TipoLinkComprendereGiocatoriGialli;
import comprendereGiocatoriRossi.TipoLinkComprendereGiocatoriRossi;

public class InserisciInTorello implements Task {

	private boolean eseguita = false;
	private HashSet<GiocatoreGiallo> hsG;
	private HashSet<GiocatoreRosso> hsR;
	private Torello torello;

	public InserisciInTorello(Torello t, HashSet<GiocatoreGiallo> hsG, HashSet<GiocatoreRosso> hsR) {
		this.torello = t;
		this.hsG = hsG;
		this.hsR = hsR;
	}

	public synchronized void esegui(Executor e) {

		if (e == null || eseguita == true)
			return;
		eseguita = true;

		Iterator<GiocatoreGiallo> itg = hsG.iterator();
		while (itg.hasNext()) torello.inserisciLinkComprendereGiocatoriGialli(new TipoLinkComprendereGiocatoriGialli(itg.next(),torello));
	
		Iterator<GiocatoreRosso> itr = hsR.iterator();
		while (itr.hasNext()) torello.inserisciLinkComprendereGiocatoriRossi(new TipoLinkComprendereGiocatoriRossi(itr.next(),torello));
				
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}

}