package attivita_atomiche;

import eventi.Inizio;
import eventi.Palla;
import giocatoreGiallo.GiocatoreGiallo;
import giocatoreRosso.GiocatoreRosso;

import java.util.Iterator;

import torello.Torello;
import torelloMultipalla.TorelloMultipalla;
import _framework.Executor;
import _framework.Task;
import _gestioneeventi.Environment;
import _gestioneeventi.EsecuzioneEnvironment;

import comprendereGiocatoriGialli.TipoLinkComprendereGiocatoriGialli;
import comprendereGiocatoriRossi.TipoLinkComprendereGiocatoriRossi;

public class Gioca implements Task {

	private boolean eseguita = false;
	private Torello torello;

	public Gioca(Torello t) {
		this.torello = t;
	}

	public synchronized void esegui(Executor e) {

		if (e == null || eseguita == true)
			return;
		eseguita = true;

		Iterator<TipoLinkComprendereGiocatoriGialli> itg = torello.getLinkComprendereGiocatoriGialli()
				.iterator();
		while (itg.hasNext()) {
			GiocatoreGiallo g = itg.next().getGiocatore();
			EsecuzioneEnvironment.addListener(g);
		}
		
		Iterator<TipoLinkComprendereGiocatoriRossi> itr = torello.getLinkComprendereGiocatoriRossi()
		.iterator();
while (itr.hasNext()) {
	GiocatoreRosso g = itr.next().getGiocatore();
	EsecuzioneEnvironment.addListener(g);
}
		
		Environment.aggiungiEvento(new Inizio(null, null));

		if (torello.getClass() == TorelloMultipalla.class)
		{
			
			TorelloMultipalla tm = (TorelloMultipalla)torello;
			int i;
			for (i = 1; i <= tm.getNumeroPalle(); i++) {
				Environment.aggiungiEvento(new Palla(null, torello
						.getLinkComprendereGiocatoriRossi().get(i-1).getGiocatore(), i));
			}
			
		}
		else Environment.aggiungiEvento(new Palla(null, torello
				.getLinkComprendereGiocatoriGialli().get(0).getGiocatore(), 1));
		
		EsecuzioneEnvironment.attivaListener();
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
}