package playlist;

import brano.*;
import contiene.*;
import java.util.*;

public class PlayList {
    private final String nome;
    private ArrayList<Brano> insieme_link;
    public PlayList(String n) {
        nome = n;
        insieme_link = new ArrayList<Brano>();
    }
    public String getNome() { return nome; }
    public void inserisciLinkContiene(Brano b) { 
      if (b != null)
	  ManagerContiene.inserisci(this,b);
    }
    public void eliminaLinkContiene(Brano b) {
      if (b != null)
	  ManagerContiene.elimina(this,b);
    }
    public List<Brano> getLinkContiene() {
        return (ArrayList<Brano>)insieme_link.clone();     
    }
    public void inserisciPerManagerContiene(ManagerContiene a){
        if (a != null && !insieme_link.contains(a.getBrano())) 
            insieme_link.add(a.getBrano());
    }      
    public void eliminaPerManagerContiene(ManagerContiene a) {
        if (a != null) insieme_link.remove(a.getBrano());
    }
    public int durataTotale() {
        int result = 0;
        Iterator<Brano> il = insieme_link.iterator();
        while (il.hasNext()) {
            Brano b = il.next();
            result = result + b.getDurata();
        }
        return result;
    }

}
	
