package brano;

import contiene.*;
import playlist.*;
import java.util.*;

public class Brano {
    private final String nome;
    private final int durata;
    private final String nomefile;
    private HashSet<PlayList> insieme_link;
    public Brano(String n, int d, String f) { 
        nome = n; 
        durata = d;
        nomefile = f;
        insieme_link = new HashSet<PlayList>();
    }
    public String getNome() { return nome; }
    public int getDurata() { return durata; }
    public String getNomeFile() { return nomefile; }
    public void inserisciLinkContiene(PlayList p) { 
      if (p != null)
	  ManagerContiene.inserisci(p,this);
    }
    public void eliminaLinkContiene(PlayList p) {
      if (p != null)
         ManagerContiene.elimina(p,this);
    }
    public Set<PlayList> getLinkContiene() {
        return (HashSet<PlayList>)insieme_link.clone();     
    }
    public void inserisciPerManagerContiene(ManagerContiene a){
        if (a != null) insieme_link.add(a.getPlayList());
    }      
    public void eliminaPerManagerContiene(ManagerContiene a) {
        if (a != null) insieme_link.remove(a.getPlayList());
    }
}
