package contiene;

import giocatore.*;

public final class ManagerContiene {
	private ManagerContiene(TipoLinkContiene t) {
		link = t;
	}

	private TipoLinkContiene link;

	public TipoLinkContiene getLink() {
		return link;
	}

	public static void inserisci(TipoLinkContiene t) {
		if (t != null) {
			if (t.getGiocatore().getStato() != Giocatore.Stato.ALLENAMENTO)
				throw new RuntimeException(
						"Non si puo' modificare il giocatore se non  in allenamento.");
			ManagerContiene k = new ManagerContiene(t);
			t.getSquadra().inserisciPerManagerContiene(k);
			t.getGiocatore().inserisciPerManagerContiene(k);
		}
	}

	public static void elimina(TipoLinkContiene t) {
		if (t != null) {
			if (t.getGiocatore().getStato() != Giocatore.Stato.ALLENAMENTO)
				throw new RuntimeException(
						"Non si puo' modificare il giocatore se non  in allenamento.");
			ManagerContiene k = new ManagerContiene(t);
			t.getSquadra().eliminaPerManagerContiene(k);
			t.getGiocatore().eliminaPerManagerContiene(k);
		}
	}
}
