package thread8queue3;
import java.util.ArrayList;
import java.util.List;

public class BoundedQueue<T> {
	
	private List<T> elements;
	private int maxSize;
	
	public BoundedQueue(int capacity) {
		elements = new ArrayList<T>();
		maxSize = capacity;
	}

	public synchronized T remove() throws InterruptedException {
		while (elements.size() == 0)
			wait();
		T r = elements.remove(0);
		System.out.println(Thread.currentThread().getName() + ": remove, size=" + elements.size());
		notifyAll();
		return r;
	}

	public synchronized void add(T newElem) throws InterruptedException {
		while (elements.size() == maxSize)
			wait();
		elements.add(newElem);
		System.out.println(Thread.currentThread().getName() + ": add, size=" + elements.size());
		notifyAll();
	}
}
