package thread8queue2;

public class Producer implements Runnable {

	private String greeting;
	private BoundedQueue queue;
	private int greetingCount;

	private static final int DELAY = 10;

	public Producer(String aGreeting, BoundedQueue aQueue, int count) {
		greeting = aGreeting;
		queue = aQueue;
		greetingCount = count;
	}

	public void run() {
		try {
			int i = 1;
			while (i <= greetingCount) {
				synchronized (queue) {
					if (!queue.isFull()) {
						queue.add(i + ": " + greeting);
						i++;
					}
				}
				Thread.sleep((int) (Math.random() * DELAY));
			}
		} catch (InterruptedException exception) {
		}
	}
}
