package cetaceo;

import acquatico.*;
import mammifero.*;

public class CetaceoIMP implements Cetaceo {

	private MammiferoIMP mammifero; // NOTA!
	private AcquaticoIMP acquatico; // NOTA!
	protected boolean presente_in_italia;

	public CetaceoIMP(String g, String s, String c, int me, float ma, boolean p) {
		mammifero = new MammiferoIMP(g, s, c, me);
		acquatico = new AcquaticoIMP("Mammifero", g, s, c, ma);
		presente_in_italia = p;
	}

	public String getOrdine() { // NOTA!
		return mammifero.getOrdine();
		// oppure
		// return acquatico.getGenere();
	}

	public String getGenere() { // NOTA!
		return mammifero.getGenere();
		// oppure
		// return acquatico.getGenere();
	}

	public String getSpecie() { // NOTA!
		return mammifero.getSpecie();
		// oppure
		// return acquatico.getGenere();
	}

	public String getCiboPreferito() { // NOTA!
		return mammifero.getCiboPreferito();
		// oppure
		// return acquatico.getGenere();
	}

	public int getMesiDiGestazione() {
		return mammifero.getMesiDiGestazione();
	}

	public float getMaxSalinitaAcqua() {
		return acquatico.getMaxSalinitaAcqua();
	}

	public boolean getPresenteInItalia() {
		return presente_in_italia;
	}
}
