package applicazione;

import java.util.*;

import squadra.*;
import _gestioneeventi.*;
import contiene.*;
import eventi.*;
import gara.*;
import giocatore.*;

public final class Main {
	public static void main(String[] args) {
		//crea prima squadra
		Squadra s1 = new Squadra("Roadrunners");
		for (int i=0; i < 10; i++) 
			s1.inserisciLinkContiene(new TipoLinkContiene(s1,new Giocatore("RR"+i,i*10+1)));
		//crea seconda squadra
		Squadra	s2 = new Squadra("Speedygonzales");
		for (int i=0; i < 10; i++) 
			s2.inserisciLinkContiene(new TipoLinkContiene(s2,new Giocatore("SG"+i,i*10+1)));
		//crea gara
		Gara g = new Gara("La Gara");	
		g.inserisciLinkPartecipa(s1);
		g.inserisciLinkPartecipa(s2);
		//stampa gara
		Stampa.stampaGara(g);	
		
		//esegui gara
		System.out.println("INIZIO GARA");
		esegui(g);
		System.out.println("FINE GARA");
	}

	private static void esegui(Gara g) {
		Environment env = new Environment();
		Iterator<Squadra> its = g.getLinkPartecipa().iterator();
		while (its.hasNext()) {
			Squadra s = its.next();
			List<TipoLinkContiene> links = s.getLinkContiene();
			Iterator<TipoLinkContiene> itc = links.iterator();
			while (itc.hasNext()) {
				Giocatore gs = itc.next().getGiocatore();
				env.addListener(gs);
				env.aggiungiEvento(new Inizio(null,gs));
			}
			env.aggiungiEvento(new Bastone(null,links.get(0).getGiocatore()));
		}
		env.eseguiEnvironment();
		
		//Rieseguiamo l'environment per rimettere i giocatori nello stato Allenamento
		//  (in alternativa essere associato un diagramma degli stati anche a gara)
		Iterator<Squadra> itss = g.getLinkPartecipa().iterator();
		while (itss.hasNext()) {
			Squadra s = itss.next();
			List<TipoLinkContiene> links = s.getLinkContiene();
			Iterator<TipoLinkContiene> itc = links.iterator();
			while (itc.hasNext()) {
				Giocatore gs = itc.next().getGiocatore();
				env.aggiungiEvento(new Fine(null,gs));
			}
		}
		env.eseguiEnvironment();
	}

	private Main() {
	}
}
