package contiene;

import brano.*;
import playlist.*;

public class TipoLinkContiene {
    private final PlayList laPlayList;
    private final Brano ilBrano;
    public TipoLinkContiene(PlayList x, Brano y) { 
        if (x == null || y == null)  // CONTROLLO PRECONDIZIONI
            throw new RuntimeException ("Gli oggetti devono essere inizializzati");
        laPlayList = x; ilBrano = y;
    }
    public boolean equals(Object o) {
        if (o != null && getClass().equals(o.getClass())) {
            TipoLinkContiene b = (TipoLinkContiene)o;
            return b.ilBrano == ilBrano && b.laPlayList == laPlayList;
        }  
        else return false;
    }  
    public int hashCode() {
        return laPlayList.hashCode() + ilBrano.hashCode();
    }
    public PlayList getPlayList() { return laPlayList; }
    public Brano getBrano() { return ilBrano; }
}

