package giocatore;

import _framework.*;
import _gestioneeventi.*;
import contiene.*;

public class Giocatore implements Listener {
	private final String nome;
	private int velocita;
	private TipoLinkContiene link;

	public Giocatore(String n, int v) {
		if (v < 1 || v > 100)
			throw new RuntimeException("Eccezione precodizione: "
					+ "parametro velocita' nominale fuori dal range ammesso");
		nome = n;
		velocita = v;
	}

	public String getNome() {
		return nome;
	}

	public void setVelocita(int velocita) {
		if (statocorrente != Stato.ALLENAMENTO)
			throw new RuntimeException(
					"Non si puo' modificare il giocatore se non  in allenamento.");
		this.velocita = velocita;
	}

	public int getVelocita() {
		return velocita;
	}

	public void inserisciLinkContiene(TipoLinkContiene t) {
		if (t != null && t.getGiocatore() == this)
			ManagerContiene.inserisci(t);
	}

	public void eliminaLinkContiene(TipoLinkContiene t) {
		if (t != null && t.getGiocatore() == this)
			ManagerContiene.elimina(t);
	}

	public TipoLinkContiene getLinkContiene() {
		if (link == null)
			throw new RuntimeException(
					"Eccezione molteplicit: la molteplicit deve essere 1..1");
		return link;
	}

	public void inserisciPerManagerContiene(ManagerContiene a) {
		if (a != null && link == null)
			link = a.getLink();
	}

	public void eliminaPerManagerContiene(ManagerContiene a) {
		if (a != null)
			link = null;
	}

	public String toString() {
		return nome;
	}

	// gestione stato

	public static enum Stato {
		ALLENAMENTO, INGIOCO, FINEGIOCO
	}

	Stato statocorrente = Stato.ALLENAMENTO; // nota visibilita' package

	double trattopercorso; // nota visibilita' package

	public Stato getStato() {
		return statocorrente;
	}

	public void fired(Evento e) {
		Executor.perform(new GiocatoreFired(this, e));
	}
}
