package attivita_atomiche;

import gara.Gara;
import giocatore.Giocatore;

import java.util.Iterator;
import java.util.List;

import squadra.Squadra;
import contiene.TipoLinkContiene;
import _framework.*;

public class TestFineGara implements Task {
	private boolean eseguita = false;
	private Gara gara;
	private boolean garafinita;

	public TestFineGara(Gara gara) {
		this.gara = gara;
	}

	public synchronized void esegui(Executor e) {
		if (e == null || eseguita == true)
			return;
		eseguita = true;
		garafinita = true;
		Iterator<Squadra> itss = gara.getLinkPartecipa().iterator();
		while (itss.hasNext()) {
			Squadra s = itss.next();
			List<TipoLinkContiene> links = s.getLinkContiene();
			Iterator<TipoLinkContiene> itc = links.iterator();
			while (itc.hasNext()) {
				Giocatore gs = itc.next().getGiocatore();
				garafinita = garafinita
						&& gs.getStato().equals(Giocatore.Stato.FINEGIOCO);
			}
		}
	}

	public synchronized boolean estGaraFinita() {
		if (!eseguita)
			throw new RuntimeException();
		return garafinita;
	}

	// env.aggiungiEvento(new Fine(null, gs));

	public synchronized boolean estEseguita() {
		return eseguita;
	}

}
