package attivita_atomiche;

import java.util.*;
import _framework.*;
import _gestioneeventi.*;
import eventi.*;
import gara.*;
import giocatore.*;
import squadra.*;
import contiene.*;

public class InizializzaEnvironment implements Task {

	private boolean eseguita = false;
	private Gara gara;

	public InizializzaEnvironment(Gara gara) {
		this.gara = gara;
	}

	public synchronized void esegui(Executor e) {
		if (e == null || eseguita == true)
			return;
		eseguita = true;
		Iterator<Squadra> its = gara.getLinkPartecipa().iterator();
		while (its.hasNext()) {
			Squadra s = its.next();
			List<TipoLinkContiene> links = s.getLinkContiene();
			Iterator<TipoLinkContiene> itc = links.iterator();
			while (itc.hasNext()) {
				Giocatore gs = itc.next().getGiocatore();
				EsecuzioneEnvironment.addListener(gs);
			}
			Environment.aggiungiEvento(new Inizio(null, null));
			Environment.aggiungiEvento(new Bastone(null, links.get(0).getGiocatore()));
		}
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
}
