package mattoncino;

import java.util.*;

import _framework.*;
import _gestioneeventi.*;

public class Mattoncino implements Listener {
	private final String codice;
	private HashSet<Mattoncino> insieme_link;

	public Mattoncino(String c) {
		codice = c;
		insieme_link = new HashSet<Mattoncino>();
	}

	public String getCodice() {
		return codice;
	}


	public void inserisciLinkCollegato(Mattoncino m) {
		if (m != null)
			insieme_link.add(m);
	}

	public void eliminaLinkCollegato(Mattoncino m) {
		if (m != null)
			insieme_link.remove(m);
	}

	@SuppressWarnings("unchecked")
	public Set<Mattoncino> getLinkCollegato() {
		return (HashSet<Mattoncino>)insieme_link.clone();
	}

	public String toString() {
		return codice;
	}

	// gestione stato

	public enum Stato {
		SPENTO, BLU, ROSSO
	}

	Stato statocorrente = Stato.SPENTO; // nota visibilita' package

	public Stato getStato() {
		return statocorrente;
	}

	public void fired(Evento e) {
		Executor.perform(new MattoncinoFired(this, e));
	}
}
