package attivita_atomiche;

import java.util.*;
import mattoncino.*;
import _framework.*;
import _gestioneeventi.*;
import eventi.*;

public class InizializzaEnvironment implements Task {

	private boolean eseguita = false;
	private List<Mattoncino> lista;

	public InizializzaEnvironment(List<Mattoncino> l) {
		if (l.size() < 2)
			throw new RuntimeException("Servono almeno due mattoncini!");
		lista = l;
	}

	public synchronized void esegui(Executor e) {
		if (e == null || eseguita == true)
			return;
		eseguita = true;
		for (int i = 0; i < lista.size(); i++) {
			Mattoncino m = lista.get(i);
			EsecuzioneEnvironment.addListener(m);
			if (Math.random() > 0.5)
				Environment.aggiungiEvento(new IniziaRosso(null, m));
			else
				Environment.aggiungiEvento(new IniziaBlu(null, m));
		}
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
}
