package possedere;

import persona.*;
import conto.*;

public class TipoLinkPossedere {

	private final Conto ilConto;
	private final Persona laPersona;

	public TipoLinkPossedere(Persona p, Conto c) throws RuntimeException {
		if (p == null || c == null) // CONTROLLO PRECONDIZIONI
			throw new RuntimeException(
					"Gli oggetti devono essere inizializzati");
		laPersona = p;
		ilConto = c;
	}

	public boolean equals(Object o) {
		if (o != null && getClass().equals(o.getClass())) {
			TipoLinkPossedere b = (TipoLinkPossedere) o;
			return b.laPersona == laPersona && b.ilConto == ilConto;
		} else
			return false;
	}

	public int hashCode() {
		return laPersona.hashCode() + ilConto.hashCode();
	}

	public Persona getPersona() {
		return laPersona;
	}

	public Conto getConto() {
		return ilConto;
	}
}
