package persona;

import possedere.*;

public class Persona {

	private final String codiceFiscale;
	private final String nome;
	private final String cognome;

	private TipoLinkPossedere linkPossedere;

	public Persona(String cf, String n, String c) {
		codiceFiscale = cf;
		nome = n;
		cognome = c;
		linkPossedere = null;
	}

	public String getCodiceFiscale() {
		return codiceFiscale;
	}

	public String getNome() {
		return nome;
	}

	public String getCognome() {
		return cognome;
	}

	// metodi per la gestione dell'associazione "possedere"
	// tra Persona e Conto
	public void inserisciLinkPossedere(TipoLinkPossedere t) {
		if (t != null && t.getPersona() == this)
			ManagerPossedere.inserisci(t);
	}

	public void eliminaLinkPossedere(TipoLinkPossedere t) {
		if (t != null && t.getPersona() == this)
			ManagerPossedere.elimina(t);
	}

	public TipoLinkPossedere getLinkPossedere() {
		return linkPossedere;
	}

	public void inserisciPerManagerPossedere(ManagerPossedere a) {
		if (a != null)
			linkPossedere = a.getLink();
	}

	public void eliminaPerManagerPossedere(ManagerPossedere a) {
		if (a != null)
			linkPossedere = null;
	}
}