package conto;

import java.util.*;

import possedere.*;
import persona.*;

public class Conto {

	private final String codice;
	private int saldo;
	private int numeroOperazioni;

	private HashSet<TipoLinkPossedere> insieme_linkPossedere;

	public Conto(String c, int s) {
		codice = c;
		saldo = s;
		numeroOperazioni = 0;
		insieme_linkPossedere = new HashSet<TipoLinkPossedere>();
	}

	public String getCodice() {
		return codice;
	}

	public int getSaldo() {
		return saldo;
	}

	public int getNumeroOperazioni() {
		return numeroOperazioni;
	}

	public void aumenta(Persona p, int q) {
		if (insieme_linkPossedere.contains(new TipoLinkPossedere(p, this))) {
			saldo = saldo + q;
			numeroOperazioni = numeroOperazioni + 1;
		}
	}

	public void diminuisci(Persona p, int q) {
		if (insieme_linkPossedere.contains(new TipoLinkPossedere(p, this))) {
			saldo = saldo - q;
			if (saldo < 0)
				saldo = 0;
			numeroOperazioni = numeroOperazioni + 1;
		}
	}

	// metodi per la gestione dell'associazione "possedere"
	// tra Persona e Conto
	public void inserisciLinkPossedere(TipoLinkPossedere t) {
		if (t != null && t.getConto() == this)
			ManagerPossedere.inserisci(t);
	}

	public void eliminaLinkPossedere(TipoLinkPossedere t) {
		if (t != null && t.getConto() == this)
			ManagerPossedere.elimina(t);
	}

	@SuppressWarnings("unchecked")
	public Set<TipoLinkPossedere> getLinkPossedere() {
		return (HashSet<TipoLinkPossedere>) insieme_linkPossedere.clone();
	}

	public void inserisciPerManagerPossedere(ManagerPossedere a) {
		if (a != null)
			insieme_linkPossedere.add(a.getLink());
	}

	public void eliminaPerManagerPossedere(ManagerPossedere a) {
		if (a != null)
			insieme_linkPossedere.remove(a.getLink());
	}
}
