package attivita_complesse;

import attivita_atomiche.*;
import attivita_io.*;
import persona.*;
import _framework.*;
import conto.*;

public class AttivitaPrincipale implements Runnable {
	
	private boolean eseguita = false;

	public synchronized void run() {
		if (eseguita == true)
			return;
		eseguita = true;
		
		Persona marito;
		Persona moglie;
		Conto conto;
		
		//operazione IO
		RecordPersonaPersonaConto ris = 
			AttivitaIO.LeggiDatiConto();
		marito = ris.marito;
		moglie = ris.moglie;
		conto = ris.conto;

		//task 
		AperturaConto ac = new AperturaConto(marito, moglie, conto);
		Executor.perform(ac);

		//operazione IO
		AttivitaIO.AperturaOK();

		while (numeroOperazioni(conto) < 15) { //NB verifica attraverso un task
		
			//attivita' complessa
			Thread ramo1 = new Thread(new AttivitaSottoramo1(moglie, conto));
			ramo1.start(); //FORK: primo ramo
			
			//attivita' complessa
			Thread ramo2 = new Thread(new AttivitaSottoramo2(marito, conto));
			ramo2.start(); //FORK: secondo ramo
			
			try {
				ramo1.join(); //JOIN: primo ramo
				ramo2.join(); //JOIN: seconso ramo
			} catch (InterruptedException e) {
				e.printStackTrace();
			}

		}
		
		//task 
		Saldo s= new Saldo(conto);
		Executor.perform(s);

		if (s.getSaldo() > 0)
			//operazione IO
			AttivitaIO.StampaOK();
		else
			//operazione IO
			AttivitaIO.StampaKO();
	}

	private int numeroOperazioni(Conto conto) {
		//task
		NumeroOperazioni no = new NumeroOperazioni(conto);
		Executor.perform(no);
		return no.getNum();
	}
	
	public synchronized boolean estEseguita() {
		return eseguita;
	}
}
