package attivita_atomiche;

	import _framework.*;
	import conto.*;

	public class Saldo implements Task {

		private boolean eseguita = false;

		private Conto conto;
		private int saldo;
		
		public Saldo(Conto c) {
			conto = c;
		}

		public synchronized void esegui(Executor e) {
			if (e == null || eseguita == true)
				return;
			eseguita = true;
			saldo = conto.getSaldo();
		}

		public int getSaldo() {
			if (!eseguita) throw new RuntimeException("Risultato non pronto");
			return saldo;
		}

		public synchronized boolean estEseguita() {
			return eseguita;
		}

	}


