package attivita_atomiche;

import attivita_io.*;
import conto.*;
import persona.*;
import _framework.*;

public class Prelevare implements Task {

	private boolean eseguita = false;
	private Persona persona;
	private Conto conto;

	public Prelevare(Persona p, Conto c) {
		persona = p;
		conto = c;
	}

	public synchronized void esegui(Executor e) {
		if (e == null || eseguita == true)
			return;
		eseguita = true;
		AttivitaIO.MandaMessaggio(persona.getNome()
				+ " sta facendo una spesa ...");
		conto.diminuisci(persona, (int) (Math.random() * 1000));
		AttivitaIO.MandaMessaggio("... il conto ora ammonta a "
				+ conto.getSaldo());
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}

}
