package attivita_atomiche;

import _framework.*;
import conto.*;

public class NumeroOperazioni implements Task {

	private boolean eseguita = false;

	private Conto conto;
	private int num;
	
	public NumeroOperazioni(Conto c) {
		conto = c;
	}

	public synchronized void esegui(Executor e) {
		if (e == null || eseguita == true)
			return;
		eseguita = true;
		num = conto.getNumeroOperazioni();
	}

	public int getNum() {
		if (!eseguita) throw new RuntimeException("Risultato non pronto");
		return num;
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}

}
