package attivita_atomiche;

import attivita_io.*;
import _framework.*;
import conto.*;
import persona.*;

public class Depositare implements Task {

	private boolean eseguita = false;
	private Persona persona;
	private Conto conto;

	public Depositare(Persona p, Conto c) {
		persona = p;
		conto = c;
	}

	public synchronized void esegui(Executor e) {
		if (e == null || eseguita == true)
			return;
		eseguita = true;
		AttivitaIO.MandaMessaggio(persona.getNome()
				+ " sta depositando dei soldi ...");
		conto.aumenta(persona, (int) (Math.random() * 900));
		AttivitaIO.MandaMessaggio("... il conto ora ammonta a "
				+ conto.getSaldo());
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}

}
