package attivita_atomiche;

import _framework.*;
import conto.*;
import persona.*;
import possedere.*;

public class AperturaConto implements Task {

	private boolean eseguita = false;

	private Persona personaInput_1;
	private Persona personaInput_2;
	private Conto contoInput;

	public AperturaConto(Persona p1, Persona p2, Conto c) {
		personaInput_1 = p1;
		personaInput_2 = p2;
		contoInput = c;
	}

	public synchronized void esegui(Executor e) {//Va usato solo da Executor
		if (e == null || eseguita == true)
			return;
		eseguita = true;
		TipoLinkPossedere poss1 = new TipoLinkPossedere(personaInput_1,
				contoInput);
		ManagerPossedere.inserisci(poss1);
		TipoLinkPossedere poss2 = new TipoLinkPossedere(personaInput_2,
				contoInput);
		ManagerPossedere.inserisci(poss2);
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}

}