package queue2;

import java.util.ArrayList;
import java.util.List;

public class BoundedQueue {

	private List<Object> elements;
	private int maxSize;

	public BoundedQueue(int capacity) {
		elements = new ArrayList<Object>();
		maxSize = capacity;
	}

	// * @precondition !isEmpty()
	public synchronized Object remove() {
		Object r = elements.remove(0);
		System.out.println(Thread.currentThread().getName() + ": remove, size=" + elements.size());
		return r;
	}

	// * @precondition !isFull();
	public synchronized void add(Object newObj) {
		elements.add(newObj);
		System.out.println(Thread.currentThread().getName() + ": add, size=" + elements.size());
	}

	public synchronized boolean isFull() {
		return elements.size() == maxSize;
	}

	public synchronized boolean isEmpty() {
		return elements.isEmpty();
	}

}
