package contiene;

import squadra.*;
import giocatore.*;

public class TipoLinkContiene {
    private final Squadra lasquadra;
    private final Giocatore ilgiocatore;
    public TipoLinkContiene(Squadra x, Giocatore y) { 
        if (x == null || y == null)  // CONTROLLO PRECONDIZIONI
            throw new RuntimeException ("Gli oggetti devono essere inizializzati");
        lasquadra = x;  ilgiocatore = y;
    }
    public boolean equals(Object o) {
        if (o != null && getClass().equals(o.getClass())) {
            TipoLinkContiene l = (TipoLinkContiene)o;
            return l.lasquadra == lasquadra && l.ilgiocatore == ilgiocatore;
        }  
        else return false;
    }  
    public int hashCode() {
        return lasquadra.hashCode() + ilgiocatore.hashCode();
    }
     public Squadra getSquadra() { return lasquadra; }
     public Giocatore getGiocatore() { return ilgiocatore; }
}

