package squadra;

import contiene.*;
import java.util.*;

public class Squadra {
    private final String nome;
    private ArrayList<TipoLinkContiene> insiemeLink;
    public final int MINCONTIENE = 10;
    public final int MAXCONTIENE = 10;
    public Squadra(String n) { 
        nome = n; 
        insiemeLink = new ArrayList<TipoLinkContiene>();
    }
    public String getNome() { return nome; }
    public void inserisciLinkContiene(TipoLinkContiene t) { 
      if (t != null && t.getSquadra()==this)
         ManagerContiene.inserisci(t);
    }
    public void eliminaLinkContiene(TipoLinkContiene t) {
      if (t != null && t.getSquadra()==this)
         ManagerContiene.elimina(t);
    }
	public List<TipoLinkContiene> getLinkContiene() {
		if (quantiContiene() < MINCONTIENE && quantiContiene() > MAXCONTIENE) 
			throw new RuntimeException("Eccezione Molteplicit: la molteplicit deve essere 10..10");
        return (ArrayList<TipoLinkContiene>)insiemeLink.clone();     
    }
    public void inserisciPerManagerContiene(ManagerContiene a){
        if (a != null && !insiemeLink.contains(a.getLink()) ) 
        	insiemeLink.add(a.getLink());
    }      
    public void eliminaPerManagerContiene(ManagerContiene a) {
        if (a != null) insiemeLink.remove(a.getLink());
    }
    public int quantiContiene(){ return insiemeLink.size(); }
}
