package giocatore;

import _gestioneeventi.*;
import contiene.*;
import squadra.*;
import eventi.*;

import java.util.*;


public class Giocatore implements Listener {
	private final String nome;
	private int velocita;
	private TipoLinkContiene link;

	public Giocatore(String n, int v) {
		if (v < 1 || v > 100) throw 
new RuntimeException("Eccezione precodizione: " +
		"parametro velocita' nominale fuori dal range ammesso");
		nome = n;
		velocita = v;
	}

	public String getNome() {
		return nome;
	}

	public void setVelocita(int velocita) {
	    if (statocorrente != Stato.ALLENAMENTO)
			  throw new RuntimeException("Non si puo' modificare il giocatore se non  in allenamento.");
		this.velocita = velocita;
	}

	public int getVelocita() {
		return velocita;
	}

	public void inserisciLinkContiene(TipoLinkContiene t) {
		if (t != null && t.getGiocatore() == this)
			ManagerContiene.inserisci(t);
	}

	public void eliminaLinkContiene(TipoLinkContiene t) {
		if (t != null && t.getGiocatore() == this)
			ManagerContiene.elimina(t);
	}

	public TipoLinkContiene getLinkContiene() {
		if (link==null) 
			throw new RuntimeException("Eccezione molteplicit: la molteplicit deve essere 1..1");
		return link;
	}

	public void inserisciPerManagerContiene(ManagerContiene a) {
		if (a != null && link == null)
			link = a.getLink();
	}

	public void eliminaPerManagerContiene(ManagerContiene a) {
		if (a != null)
			link = null;
	}

	public String toString() {return nome; }	
	
	// gestione stato

	public enum Stato {
		ALLENAMENTO, INGIOCO, FINEGIOCO
	}

	private Stato statocorrente = Stato.ALLENAMENTO;

	private double trattopercorso;

	public Stato getStato() {
		return statocorrente;
	}

	public Evento fired(Evento e) {
		// filtra eventi non per this o non in broadcasting
		if (e.getDestinatario() != this && e.getDestinatario() != null)
			return null;

		Evento nuovoevento = null;
		switch (statocorrente) {
		case ALLENAMENTO:
			if (e.getClass() == Inizio.class) {
				trattopercorso = 0;	
				statocorrente = Stato.INGIOCO;
			}
			break;
		case INGIOCO:
			if (e.getClass() == Bastone.class)
				if (trattopercorso < 100) {
					System.out.println(this + ": " + trattopercorso);
					trattopercorso = trattopercorso + Math.random()*velocita+1;
					nuovoevento = new Bastone(this, this);
					statocorrente = Stato.INGIOCO;
				} else { //trattopercorso >= 100
					System.out.println(this + ": " + trattopercorso);
					Squadra sc = this.getLinkContiene().getSquadra();
					List<TipoLinkContiene> links = sc.getLinkContiene();
					int i = links.indexOf(new TipoLinkContiene(sc,this));
					if (i+1 < sc.getLinkContiene().size()) {
						Giocatore prossimo = links.get(i+1).getGiocatore();
						nuovoevento = new Bastone(this,prossimo);
					}
					statocorrente = Stato.FINEGIOCO;
				}
			break;
		case FINEGIOCO:
			if (e.getClass() == Fine.class)
					statocorrente = Stato.ALLENAMENTO;
			break;
		default:
			throw new RuntimeException("Stato corrente non riconosciuto.");
		}
		return nuovoevento;
	}
}
