package gara;

import squadra.*;

import java.util.*;

public class Gara {
	private final String nome;
	private HashSet<Squadra> insiemeLink;
	public final int MINPARTECIPA = 2;

	public Gara(String n) {
		nome = n;
		insiemeLink = new HashSet<Squadra>();
	}

	public String getNome() {
		return nome;
	}

	public void inserisciLinkPartecipa(Squadra s) {
		if (s != null)
			insiemeLink.add(s);
	}

	public void eliminaLinkPartecipa(Squadra s) {
		if (s != null)
			insiemeLink.remove(s);
	}

	public Set<Squadra> getLinkPartecipa() {
		if (quanteSquadre() < MINPARTECIPA)
			throw new RuntimeException(
					"Eccezione Molteplicit: la molteplicit deve essere 2..*");
		return (HashSet<Squadra>) insiemeLink.clone();
	}

	public int quanteSquadre() {
		return insiemeLink.size();
	}

}
