package segmento;
import punto.*;

public class Segmento implements Cloneable {
  protected Punto iniz;
  protected Punto fin;
  
  public Segmento(Punto i, Punto f) {
    iniz = i;
    fin = f;
  }

  public Punto puntoIniziale() {
    return iniz;
  }
  
  public Punto puntoFinale() {
    return fin;
  }

  public boolean equals(Object o) {
    if  (o != null && getClass().equals(o.getClass())) {
      Segmento s = (Segmento)o;
      return iniz.equals(s.iniz) && fin.equals(s.fin);
      //return iniz == s.iniz && fin == s.fin; NO!!!!
    }
    else return false;    
  }
  
  public Object clone() {
    try {
      Segmento s = (Segmento)super.clone();
      s.iniz = (Punto)iniz.clone();
      s.fin = (Punto)fin.clone();
      return s;
    } 
    catch (CloneNotSupportedException e){
      throw new InternalError(e + "???");
    }
  }
  
}
