package punto;

public class Punto implements Cloneable {
  protected double x;
  protected double y;
  protected double z;

  public Punto(double x, double y, double z) {
    this.x=x;
    this.y=y;
    this.z=z;
  }

  public Punto() {
    //x = 0;
    //y = 0;
    //z = 0;  oppure
    this(0,0,0);
  }

  public double getX() {
    return x;
  }
  public double getY() {
    return y;
  }
  public double getZ() {
    return z;
  }
  
  public boolean equals(Object o) {
    if  (o != null && getClass().equals(o.getClass())) {
      Punto p = (Punto)o;
      return x == p.x && y == p.y && z == p.z;
    }
    else return false;    
  }

  public Object clone() {
    try {
       Punto p = (Punto)super.clone();
       // non devo fare altro sui campi di p
       return p;
    } 
    catch (CloneNotSupportedException e){
      throw new InternalError(e + "???");
    }


  }


}
