import punto.*;
import puntocolorato.*;
import segmento.*;
import segmento_orientato.*;


public class Main {

  
  public static void main(String[] args) {
    Punto p1 = new Punto(10,10,10);
    //System.out.println("PUNTO: " + p1.getX() + p1.getY() + p1.getZ());
    stampaPunto(p1);
    
    PuntoColorato p2 = new PuntoColorato(10,20,30,100);
    //System.out.println("PUNTO: " + p2.getX() + p2.getY() + p2.getZ());
    //System.out.println("COLORE: " + p2.getColore());
    stampaPunto(p2);
    stampaColorePunto(p2);

    Segmento s = new Segmento(p1, p2);
    Segmento ss = new SegmentoOrientato(p1, p2, true);
    stampaSegmento(s);
    stampaSegmento(ss);
    
    System.out.println(((SegmentoOrientato)ss).daInizialeAFinale());
    
    
    Punto p11 = (Punto)p1.clone();
    
    PuntoColorato p22 = (PuntoColorato)p2.clone();
    
    System.out.println(p1.equals(p11));
    System.out.println(p2.equals(p22));
    
    SegmentoOrientato sss = (SegmentoOrientato)ss.clone();
    System.out.println(ss.equals(sss));
  }

  //funzioni ausiliarie

  private static void stampaSegmento(Segmento s) {
    System.out.println("SEGMENTO");
    stampaPunto(s.puntoIniziale());
    stampaPunto(s.puntoFinale());
  }

  private static void stampaPunto(Punto p) {
    System.out.println("PUNTO: " + p.getX() +", "+ p.getY() +", "+ p.getZ());
  }

  private static void stampaColorePunto(PuntoColorato p) {
    System.out.println("COLORE: " + p.getColore());
  }

}
