package insiemelista;

public class InsiemeListaOmogeneo extends InsiemeLista {

  // campi dati
  protected Class elemClass;

  // costruttori
  public InsiemeListaOmogeneo(Class cl) {
    super();
    elemClass = cl;
  }

  public InsiemeListaOmogeneo() {
    this(Object.class);
  }

  // overriding funzioni proprie della classe
  // (realizzazione delle funzioni di Set)

  // overriding delle basic operations

  public boolean contains(Object e) {
    if (!elemClass.isInstance(e)) return false;
    else return super.contains(e);
  }

  public boolean add(Object e) {
    if (!elemClass.isInstance(e)) return false;
    else return super.add(e);
  }

  public boolean remove(Object e) {
    if (!elemClass.isInstance(e)) return false;
    else return super.remove(e);
  }

  // overriding delle bulk operations: non serve

  // overriding delle array operations: non serve

  // overriding delle funzioni speciali ereditate da Object
  public boolean equals(Object o) {
    if (super.equals(o)) {
      InsiemeListaOmogeneo ins = (InsiemeListaOmogeneo)o;
      if (elemClass.equals(ins.elemClass)) return true;
      else return false;
    }
    else return false;
  }

  public Object clone() {
    InsiemeListaOmogeneo ins = (InsiemeListaOmogeneo)super.clone();
    return ins;  // Nota: clone() di Object si occupa gia' della copia
                 //(superficiale) del campo elemClass.
 
    //oppure semplicemente: return super.clone();
  }

}
