package insiemelista;

import java.util.*;
import java.lang.reflect.Array;

class Nodo {
  Object info;
  Nodo next;
}

public class InsiemeLista implements Set, Cloneable {

  // campi dati
  protected Nodo inizio;
  protected int cardinalita;

  // costruttori
  public InsiemeLista() {
    inizio = null;
    cardinalita = 0;
  }

  // funzioni proprie della classe
  // (realizzazione delle funzioni di Set)

  // basic operations
  public int size() {
    return cardinalita;
  }

  public boolean isEmpty() {
    return inizio == null;
  }

  public boolean contains(Object e) {
    return appartiene(e,inizio);
  }

  public boolean add(Object e) {
    if (appartiene(e,inizio)) return false;
    else {
      Nodo l = new Nodo();
      l.info = e;
      l.next = inizio;
      inizio = l;
      cardinalita = cardinalita + 1;
      return true;
    }
  }

  public boolean remove(Object e) {
    if (!appartiene(e,inizio)) return false;
    else {
      inizio = cancella(e,inizio);
      cardinalita = cardinalita - 1;
      return true;
    }
  }

  public Iterator iterator() {
    return new IteratorInsiemeLista(this);
  }


  // bulk operations
  public boolean containsAll(Collection c) {
    Iterator it = c.iterator();
    while (it.hasNext()) {
      Object e = it.next();
      if (!contains(e)) return false;
    }
    return true;
  }

  public boolean addAll(Collection c){ 
    throw new UnsupportedOperationException("addlAll() non e' supportata");
  }
  public boolean removeAll(Collection c) {
    throw new UnsupportedOperationException("removeAll() non e' supportata");
  }
  public boolean retainAll(Collection c) {
    throw new UnsupportedOperationException("retainAll() non e' supportata");
  }
  public void clear() {
    throw new UnsupportedOperationException("clear() non e' supportata");
  }

  // array operations
  public Object[] toArray() {
    Object[] a = new Object[size()];
    int i = 0;
    Iterator it = iterator();
    while (it.hasNext()) {
      a[i] = it.next();
      i++;
    }
    return a;
  }

  public Object[] toArray(Object[] a) {
    if (a.length < size()) {
      //prendi il tipo degli elementi di a
      Class elemClass = a.getClass().getComponentType(); 
      //costruisci un array il cui tipo degli elementi e' quello in a
      a = (Object[])Array.newInstance(elemClass,size());
    }
    //riempi l'array con gli elementi della collezione
    int i = 0;
    Iterator it = iterator();
    while (it.hasNext()) {
      a[i] = it.next();
      i++;
    }
    for (; i < a.length; i++) 
      a[i] = null;
    return a;  
  } 
    

  // funzioni speciali ereditate da Object
  public boolean equals(Object o) {
    if (o != null && getClass().equals(o.getClass())) {
      InsiemeLista ins = (InsiemeLista)o;
      if (cardinalita != ins.cardinalita) return false;
      // ins non ha la cardinalita' giusta
      else {
        // verifica che gli elementi nella lista siano gli stessi
        Nodo l = inizio;
        while (l != null) {
          if (!appartiene(l.info,ins.inizio))
            return false;
          l = l.next;
        }
        return true;
      }
    }
    else return false;
  }

  public Object clone() {
    try {
      InsiemeLista ins = (InsiemeLista) super.clone();
      // chiamata a clone() di Object che esegue la copia campo a campo;
      // questa copia e' sufficiente per i campi cardinalita e elemClass
      // ma non per il campo inizio del quale va fatta una copia profonda
      ins.inizio = copia(inizio);
      return ins;
    } catch(CloneNotSupportedException e) {
      // non puo' accadere perche' implementiamo l'interfaccia cloneable,
      // ma va comunque gestita
      throw new InternalError(e.toString());
    }
  }
  public String toString() {
    String s = "{ ";
    Nodo l = inizio;
    while (l != null) {
      s = s + l.info + " ";
      l = l.next;
    }
    s = s + "}";
    return s;
  }

  // funzioni ausiliarie

  protected static boolean appartiene(Object e, Nodo l){
    return (l != null) && (l.info.equals(e) || appartiene(e,l.next));
  }

  protected static Nodo copia (Nodo l) {
    if (l == null) return null;
    else {
      Nodo ll = new Nodo();
      ll.info = l.info;
      ll.next = copia(l.next);
      return ll;
    }
  }
  protected static Nodo cancella(Object e, Nodo l) {
    if (l == null) return null;
    else if (l.info.equals(e)) return l.next;
    else {
      l.next = cancella(e,l.next);
      return l;
    }
  }
}
